unit Userlist;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  Forms, 
  Dialogs, 
  StdCtrls, 
  ExtCtrls, 
  Nwtools, 
  Nwlib,
  NWServer, 
  Buttons;

type
  TwinUserList = class(TForm)
    mainPanel: TPanel;
    listPanel: TPanel;
    dataPanel: TPanel;
    userListBox: TListBox;
    closeBtn: TBitBtn;
    fullUserName: TEdit;
    netAddrs: TComboBox;
    stationAddrs: TComboBox;
    loginTime: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    serverListPanel: TPanel;
    serverCombo: TComboBox;
    procedure userListBoxClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winUserList: TwinUserList;

implementation

{$R *.DFM}

procedure TwinUserList.userListBoxClick(Sender: TObject);
  var
    nConns,
    nLoop       : integer        ;
    connectInfo : TNWConnectInfo ;
    connList    : TConnList      ;
    userName    : string         ;
  begin
    {Get User's Login Connection List, then look at on each one }
    nConns := 0 ;
    userName := userListBox.items[userListBox.itemIndex] ;
    if (not getUserConnList(0,userName,nConns,connList)) then
      begin
        alertBox('Error Retrieving User Connection List') ;
        exit ;
      end
    else if (nConns < 1) then
      begin
        alertBox(userName + ';;Unable to Retrieve Connection Information for Object') ;
        exit ;
      end;

    {get user conn...show info}
    {fill internet/connectID combos}
    stationAddrs.clear ;
    netAddrs.clear ;
    for nloop := 0 to (nConns-1) do begin
      if getConnectInfo(getPrimaryServerID, 
                        connList[nloop],
                        connectInfo) then
        begin
          fullUserName.text := fullName(0,userName) + ' @ ' +
                               connectInfo.serverName ;
          { Add Items to ComboBoxes }
          netAddrs.items.add(connectInfo.internet) ;
          stationAddrs.items.add(intToStr(connList[nloop])) ;
        end;  
    end;
    { if only one item, change combobox style }
    if (netAddrs.items.count > 1) then
      netAddrs.style := csDropDownList 
    else
      netAddrs.style := csSimple ;
    if (stationAddrs.items.count > 1) then
      stationAddrs.style := csDropDownList 
    else
      stationAddrs.style := csSimple ;
    loginTime.text    := dateTimeToStr(connectInfo.loginDateTime)  ;
    netAddrs.text     := netaddrs.items[0] ;
    stationAddrs.text := stationAddrs.items[0] ;
  end;      

end.
 